Attribute VB_Name = "SAM1GLB"
'********** program SAM1 *************

'Sam Cohen 1/20/92
'Modified 3/1/92, 7/17/92, 2/22/93, 4/21/93, 5/13/93

'
'*************************************************************************
'Begin: global declarations specific to program SAM1:

Global Const VB1TRUE = -1   '(to avoid conflict with VB2 and VB3)
Global Const VB1FALSE = 0   '(to avoid conflict with VB2 and VB3)

Global Const DatasetName = "SAM1DAT"    'NOTE!! DEFAULT DIRECTORY (If
                                        'you're running in interpreted
                                        'mode, it's where the VB.EXE
                                        'interpreter lives; if you're
                                        'running in compiled mode, it's
                                        'where your EXE program lives.
                                        'I really recommend adding an
                                        'explicit pathname.)

Global rc As Integer    '"rc" stands for "return code"
Global Handle As Integer

Type RecordStructureType
    LastName            As String   '  <-- secondary index key...field 1
    Nickname            As String
    JobTitle            As String   '  <-- secondary index key...field 3
    Department          As String   '  <-- secondary index key...field 4
    Salary              As Integer
    GolfScore           As Integer
End Type

Global PersonRecord As RecordStructureType

Global SocSecNo As String   'This is the primary key.

Global Const RECORDFORMAT = "X20$, $, X20$, X20$, %, %"
Global Const XSOCSECNO = 0
Global Const XLASTNAME = 1
Global Const XJOBTITLE = 3
Global Const XDEPARTMENT = 4
Global SelectedIndex As Integer

Global GroupKey As String
Global SaveKey As String
Global DisplayString As String
Global SaveDisplayString As String

Global IndexChoice As Integer
Global FindTypeChoice As Integer

'End of declarations specific to SAM1.
'*************************************************************************

'In a normal program, you'd just include the module VBIS4016.BAS.  In this
'sample program, however, to avoid pathname confusion, I've just copied
'the entire contents of VBIS4016.BAS right here.  You're welcome to do the
'same thing in your apps, of course.  Confused yet?

'*************************************************************************
'***************************************************************************
' VBIS4016.BAS
'
' VB/ISAM, VB/ISAM MX & VB/ISAM MU - Copyright (c) Software Source 1991-1995;
' all rights reserved.  VB/ISAM is a proprietary computer software product
' provided by its copyright holder, Software Source (835 Blossom Hill Rd.,
' San Jose, CA); both the software and its documentation are copyrighted,
' and you may not copy or use either except as expressly provided
' in the VB/ISAM Software License.
'***************************************************************************

Option Explicit

Global Const VIS_OK = 0
Global Const VIS_NOT_FOUND = 1
Global Const VIS_UPDATE_VIOLATION = 2
Global Const VIS_ACCESS_DENIED = 3
Global Const VIS_BAD_DATASET_NUMBER = 4
Global Const VIS_BAD_FORMAT = 5
Global Const VIS_INVALID_KEY = 6
Global Const VIS_BAD_PARAMETER_VALUE = 7
Global Const VIS_BAD_FILE = 8
Global Const VIS_ALREADY_EXISTS = 9
Global Const VIS_NO_ROOM = 10
Global Const VIS_DISK_FULL = 11
Global Const VIS_OUT_OF_MEMORY = 12
Global Const VIS_DOS_ERROR = 13
Global Const VIS_DISK_ERROR = 14
Global Const VIS_DATA_VALIDITY_CHECK = 15
Global Const VIS_INVALID_SECONDARY_KEY = 16
Global Const VIS_SEQUENCE_ERROR = 17
Global Const VIS_OUT_OF_FILE_HANDLES = 18
Global Const VIS_BUSY = 19
Global Const VIS_INVALID_PASSWORD = 20
Global Const VIS_FUNCTION_NOT_AVAILABLE = 21
Global Const VIS_INTERUPTED = 22

Global Const ADD_OR_REPLACE = 0
Global Const ADD_ONLY = 1
Global Const REPLACE_ONLY = 2

Global Const READ_ONLY = 0
Global Const READ_WRITE = 1
Global Const READ_ONLY_SHARE = 2
Global Const READ_ONLY_SHARED = 2
Global Const READ_WRITE_SHARE = 3
Global Const READ_WRITE_SHARED = 3

Global Const XLOOKUP = 1
Global Const XNEXT = 2
Global Const XPREVIOUS = 4
Global Const XCURRENT = 8

Global Const XANY = 16
Global Const XEQ = 32
Global Const XBEGINS = 64
Global Const XNOT = 128
Global Const XLT = 256
Global Const XGT = 512
Global Const XLE = 1024
Global Const XGE = 2048

Global Const XGET_DATA = 4096
Global Const XNO_DATA = 8192
Global Const XNATIVE = 16384

Global Const NO_CACHE = -1
Global Const SMALL_CACHE = 0
Global Const LARGE_CACHE = 1

Type VBISAMInfo
    RecordsInFile           As Long
    GroupsUsed              As Integer
    AllocatedGpsAvail       As Integer
    MaxPrimaryKeyLen        As Integer
    GroupSize               As Long
    InitialAllocation       As Integer
    IncrementalAllocation   As Integer
    FreeFileNoteSpace       As Integer
    StandardFormat          As String
    Reserved                As String
End Type

'***************************************************************************

Declare Function VmxCreate Lib "VBIS4016.DLL" (DatasetName$, MaxKeyLength%, GroupSize&, InitialAllocation%, IncrementalAllocation%, RecFormat$) As Integer
Declare Function VmxKill Lib "VBIS4016.DLL" (DatasetName$) As Integer

Declare Function VmxOpen Lib "VBIS4016.DLL" (DatasetName$, LocatorLength%, AccessMode%, RHandle%, Password$) As Integer
Declare Function VmxClose Lib "VBIS4016.DLL" (DatasetHandle%) As Integer

Declare Function VmxPut Lib "VBIS4016.DLL" (DatasetHandle%, Key$, RecordVariable As Any, UpdateMode%) As Integer
Declare Function VmxDelete Lib "VBIS4016.DLL" (DatasetHandle%, Key$) As Integer

Declare Function VmxGet Lib "VBIS4016.DLL" (DatasetHandle%, SecIndexField%, Options%, SelectorKey$, RSecondaryKey$, RPrimaryKey$, RRecordVariable As Any) As Integer

Declare Function VmxBOF Lib "VBIS4016.DLL" (DatasetHandle%, SecIndexField%) As Integer
Declare Function VmxEOF Lib "VBIS4016.DLL" (DatasetHandle%, SecIndexField%) As Integer

Declare Function VmxWriteNote Lib "VBIS4016.DLL" (DatasetHandle%, AttributeStringName$, AttributeStringContents$) As Integer
Declare Function VmxReadNote Lib "VBIS4016.DLL" (DatasetHandle%, Aname$, RAcontents$) As Integer

Declare Function VmxFlush Lib "VBIS4016.DLL" (DatasetHandle%) As Integer

Declare Function VmxInfo Lib "VBIS4016.DLL" (DatasetHandle%, VBISAMInfoStruct As VBISAMInfo) As Integer
Declare Function VmxReturnCode Lib "VBIS4016.DLL" (FunctionReturnCode%) As String

Declare Function VmxEncode Lib "VBIS4016.DLL" (InStructure As Any, RecFormat$, ROutString$) As Integer
Declare Function VmxDecode Lib "VBIS4016.DLL" (InString$, RecFormat$, ROutStructure As Any) As Integer

' multiuser functions

Declare Function VmxLock Lib "VBIS4016.DLL" (DatasetHandle%, Key$) As Integer
Declare Function VmxUnlock Lib "VBIS4016.DLL" (DatasetHandle%, Key$) As Integer

Declare Function VmxHash Lib "VBIS4016.DLL" (DatasetHandle%, Key$) As Long

' field functions

Declare Function VmxStoreField Lib "VBIS4016.DLL" (DatasetHandle%, RecFormat$, Record$, FieldNo%, FieldType$, FldData As Any) As Integer
Declare Function VmxFetchField Lib "VBIS4016.DLL" (DatasetHandle%, RecFormat$, Record$, FieldNo%, FieldType$, RFldData As Any) As Integer
Declare Function VmxFieldNumber Lib "VBIS4016.DLL" (DatasetHandle%, FieldName$) As Integer

' move funcitons

Declare Function VmxMovePtr Lib "VBIS4016.DLL" (DatasetHandle%, SecIndexField%, RelativeCount&, XOption%) As Integer
Declare Function VmxCancel Lib "VBIS4016.DLL" (DatasetHandle%) As Integer

' debuging functions

'Declare Function VmxExtendedError Lib "VBIS4016.DLL" (DatasetHandle%, RExtendedError%) As Integer
'Declare Function VmxBreak         Lib "VBIS4016.DLL" (Flg%) As Integer

' End VBIS4016.BAS
'****************************************************************************
